/**

 * HighRoller Theme for use with Highcharts

 * @author John McLaughlin

 *

 * Licensed to Gravity.com under one or more contributor license agreements.

 * See the NOTICE file distributed with this work for additional information

 * regarding copyright ownership.  Gravity.com licenses this file to you use

 * under the Apache License, Version 2.0 (the License); you may not this

 * file except in compliance with the License.  You may obtain a copy of the

 * License at

 *

 *    http://www.apache.org/licenses/LICENSE-2.0

 *

 * Unless required by applicable law or agreed to in writing, software

 * distributed under the License is distributed on an AS IS BASIS,

 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.

 * See the License for the specific language governing permissions and

 * limitations under the License.

 */



Highcharts.theme = {

	colors: ["#DDDF0D", "#7798BF", "#55BF3B", "#DF5353", "#aaeeee", "#ff0066", "#eeaaee", 

		"#55BF3B", "#DF5353", "#7798BF", "#aaeeee"],

	chart: {

		backgroundColor: {

			linearGradient: [0, 0, 0, 400],

			stops: [

				[0, 'rgb(96, 96, 96)'],

				[1, 'rgb(16, 16, 16)']

			]

		},

		borderWidth: 0,

		borderRadius: 15,

		plotBackgroundColor: null,

		plotShadow: false,

		plotBorderWidth: 0

	},

	title: {

		style: { 

			color: '#FFF',

			font: '16px Lucida Grande, Lucida Sans Unicode, Verdana, Arial, Helvetica, sans-serif'

		}

	},

	subtitle: {

		style: { 

			color: '#DDD',

			font: '12px Lucida Grande, Lucida Sans Unicode, Verdana, Arial, Helvetica, sans-serif'

		}

	},

	xAxis: {

		gridLineWidth: 0,

    lineColor: '#555',

    tickColor: '#555',

		labels: {

			style: {

				color: '#999',

				fontWeight: 'bold'

			}

		},

		title: {

			style: {

				color: '#AAA',

				font: 'bold 12px Lucida Grande, Lucida Sans Unicode, Verdana, Arial, Helvetica, sans-serif'

			}				

		}

	},

	yAxis: {

    gridLineColor: '#c1c1c1',

    alternateGridColor: null,

		minorTickInterval: null,

		lineWidth: 0,

		tickWidth: 0,

		labels: {

			style: {

				color: '#999',

				fontWeight: 'bold'

			}

		},

		title: {

			style: {

				color: '#AAA',

				font: 'bold 12px Lucida Grande, Lucida Sans Unicode, Verdana, Arial, Helvetica, sans-serif'

			}				

		}

	},

	legend: {

		itemStyle: {

			color: '#222'

		},

		itemHoverStyle: {

			color: '#555'

		},

		itemHiddenStyle: {

			color: '#ccc'

		}

	},

	labels: {

		style: {

			color: '#CCC'

		}

	},

	tooltip: {

		backgroundColor: {

			linearGradient: [0, 0, 0, 50],

			stops: [

				[0, 'rgba(217, 217, 217, 217)'],

				[1, 'rgba(255, 255, 255, 255)']

			]

		},

		borderWidth: 0,

		style: {

			color: '#555'

		}

	},

	

	

	plotOptions: {

		line: {

			dataLabels: {

				color: '#CCC'

			},

			marker: {

				lineColor: '#333'

			}

		},

		spline: {

			marker: {

				lineColor: '#333'

			}

		},

		scatter: {

			marker: {

				lineColor: '#333'

			}

		}

	},

	

	toolbar: {

		itemStyle: {

			color: '#CCC'

		}

	},

	

	navigation: {

		buttonOptions: {

			backgroundColor: {

				linearGradient: [0, 0, 0, 20],

				stops: [

					[0.4, '#606060'],

					[0.6, '#333333']

				]

			},

			borderColor: '#000000',

			symbolStroke: '#C0C0C0',

			hoverSymbolStroke: '#FFFFFF'

		}

	},

	

	exporting: {

		buttons: {

			exportButton: {

				symbolFill: '#55BE3B'

			},

			printButton: {

				symbolFill: '#7797BE'

			}

		}

	},	

	

	// special colors for some of the demo examples

	legendBackgroundColor: 'rgba(48, 48, 48, 0.8)',

	legendBackgroundColorSolid: 'rgb(70, 70, 70)',

	dataLabelsColor: '#444',

	textColor: '#E0E0E0',

	maskColor: 'rgba(255,255,255,0.3)'

};



// Apply the theme

var highchartsOptions = Highcharts.setOptions(Highcharts.theme);

