# Contributing

Hi there.

Thanks for your interest in Parsley and your will to contribute. You're welcome!

Here are a few simple rules you'll have to follow in order to ease code reviews,
discussions and PR merging.

1) You MUST follow Parsley coding standard. It basically follows
[these popular rules](http://sideeffect.kr/popularconvention#javascript) except that
functions are followed by one space on Parsley. Use two spaces as tabs.

2) You MUST write / update tests for each code contribution you do

3) You MUST commit a passing test-suite

4) You SHOULD write documentation

Please, write [commit messages that make
sense](http://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html),
and [rebase your branch](http://git-scm.com/book/en/Git-Branching-Rebasing)
before submitting your Pull Request.

One may ask you to [squash your
commits](http://gitready.com/advanced/2009/02/10/squashing-commits-with-rebase.html)
too. This is used to "clean" your Pull Request before merging it (we don't want
commits such as `fix tests`, `fix 2`, `fix 3`, etc.).

Also, while creating your Pull Request on GitHub, you MUST write a description
which gives the context and/or explains why you are creating it.

Thank you!


Inspired by http://williamdurand.fr/2013/07/04/on-open-sourcing-libraries/
